(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22968,        700]
NotebookOptionsPosition[     22339,        673]
NotebookOutlinePosition[     22732,        690]
CellTagsIndexPosition[     22689,        687]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " Example: Asteroids\n\n",
 StyleBox["This is an advanced example that demonstrates a version of the \
classic Asteroids video game, programmed entirely in ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[". This example was written early in the development of .NET/Link, \
as a stress test to see what was possible. It might be too complex to be of \
great value for learning, but it is too unique not to include. A complete \
Asteroids game in about 350 lines of code!\n\nSome of the techniques \
demonstrated include:\n\t- using ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["DefineDLLFunction",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" to import Windows API functions into ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["\n\t- handling a component's Paint event with ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" code that draws using methods from the Graphics class\n\t- using \
a Windows Forms ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Timer",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" to trigger continuous calls from .NET back to ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["\n\n",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["To try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Section"],

Cell["\<\
BeginPackage[\"Asteroids`\", {\"NETLink`\"}];

Needs[\"Geometry`Rotations`\"];


Asteroids::usage = \"Asteroids[] launches a Mathematica-programmed version of \
the classic Asteroids arcade game.\";


Begin[\"`Private`\"];

wasOff1 = Head[General::spell] === $Off;
wasOff2 = Head[General::spell1] === $Off;
Off[General::spell];
Off[General::spell1];

(************************************  Constants  \
*******************************************)

(* Change these to alter properties/behavior of the game. *)

$FieldWidth = 500;
$FieldHeight = 400;

$FrameRate = 18;

$NumShips = 3;
$ShipBonusScore = 5000;

$SmallAsteroidRadius = 7.;
$MediumAsteroidRadius = 12.;
$LargeAsteroidRadius = 18.;

(* Speeds in pixels/frame (first number in these computations is \
pixels/second) *)
$SmallAsteroidSpeed = 60.0/$FrameRate;
$MediumAsteroidSpeed = 45.0/$FrameRate;
$LargeAsteroidSpeed = 35.0/$FrameRate;

$BulletSpeed = 300./$FrameRate;
$MaxBullets = 5;
$FireInterval = 225;  (* millis between firing *)

$ThrustBoost = 0.5;
(* Fraction of speed loss per frame. First number is fraction/second. *)
$SpeedAttrition = .25/$FrameRate;

$NumStartingAsteroids = 4;

$ShipRotationSpeed = 2Pi/18.;

$ShipOutline = {{7,0}, {-4,4}, {-3,0}, {-4,-4}};
$ShipHitOutline = {{7,0}, {2,2}, {-4,4}, {-3,0}, {-4,-4}, {2,-2}};
$ThrustOutline = {{-8.,0.}, {-3.5,2.}, {-3.,0.}, {-3.5,-2.}};
$AsteroidOutlines = {
    {{3.,-9.}, {5.,-5.}, {9.,-1.}, {9.,5.}, {-1.,9.}, {-3.,5.}, {-7.,5.}, \
{-9.,0.}, {-7.,-5.}, {-3.,-3.}, {-3.,-9.}} / 9,
    {{3.,-9.}, {3.,-5.}, {9.,-3.}, {7.,5.}, {1.,3.}, {3.,9.}, {-3.,9.}, \
{-9.,5.}, {-9.,-3.}, {-5.,-5.}, {-3.,-9.}} / 9,
    {{3.,-9.}, {3.,-3.}, {7.,-7.}, {9.,-1.}, {7.,5.}, {1.,9.}, {-1.,3.}, \
{-3.,7.}, {-9.,1.}, {-9.,-3.}, {-1.,-9.}} / 9
};


(**********************************  Global Variables  \
*************************************)

(* These globals are like instance variables if Asteroids was a class. *)

$asteroids;
$ship;
$bullets;
$lastFireTime;
$isThrusting;
$curSound;
$score;
$gameState;
$shipsLeft;
$level;
$lastFrameTicks;
$bonusCount;

(* All the following globals hold .NET objects. *)

$mat;
$keyArray;
$scorePanel;

$pen;
$pen2;
$font;
$brush;
$format;

$shipPts;
$thrustPts;
$largeAsteroidPts;
$mediumAsteroidPts;
$smallAsteroidPts;


(**********************************  Functions  \
*************************************)

(* Not truly random because field is not square. *)
randomEdgePosition[] :=
\tSwitch[Random[Integer, {1, 4}],
\t\t1, {Random[Integer, {1, $FieldWidth}], 0},
\t\t2, {$FieldWidth, Random[Integer, {1, $FieldHeight}]},
\t\t3, {Random[Integer, {1, $FieldWidth}], $FieldHeight},
\t\t4, {0, Random[Integer, {1, $FieldHeight}]}
\t]
\t
\t
resetGame[] :=
\t(
\t\t$asteroids = Table[createAsteroid[\"large\", randomEdgePosition[]], \
{$NumStartingAsteroids}];
\t\t$ship = Ship[$FieldWidth/2, $FieldHeight/2, 0, 0, 0., 0];
\t\t$bullets = {};
\t\t$lastFireTime = 0;
\t\t$score = 0;
\t\t$gameState = \"new\";
\t\t$shipsLeft = $NumShips;
\t\t$level = 0;
\t\t$bonusCount = 1;
\t)


createAsteroid[size_String, {posX_, posY_}] :=
\tModule[{pts, speed, radius},
\t\tSwitch[size,
\t\t\t\"large\",
\t\t        pts = $largeAsteroidPts[[ Random[Integer, {1, \
Length[$largeAsteroidPts]}] ]];
\t\t        radius = $LargeAsteroidRadius;
\t\t\t\tspeed = $LargeAsteroidSpeed (1 + Random[Real, {-.1, .1}]),
\t\t\t\"medium\", 
\t\t        pts = $mediumAsteroidPts[[ Random[Integer, {1, \
Length[$mediumAsteroidPts]}] ]];
\t\t        radius = $MediumAsteroidRadius;
\t\t\t\tspeed = $MediumAsteroidSpeed (1 + Random[Real, {-.1, .1}]),
\t\t\t\"small\", 
\t\t        pts = $smallAsteroidPts[[ Random[Integer, {1, \
Length[$smallAsteroidPts]}] ]];
\t\t        radius = $SmallAsteroidRadius;
\t\t\t\tspeed = $SmallAsteroidSpeed (1 + Random[Real, {-.1, .1}])
\t\t];
\t\tasteroid[posX, posY, speed, Random[Real, {0, 2Pi}], radius, pts]
\t]
\t
\t
(* This function is wired to the score panel's Paint event. *)
onPaintScore[obj_, evt_] :=
    Module[{g},
\t\tg = evt@Graphics;
\t\tg@DrawLine[$pen, 0, 59, $FieldWidth, 59];
\t\tg@DrawString[ToString[$score], $font, $brush, $FieldWidth/2., 20., \
$format];
\t\tDo[
\t\t    $mat@Reset[];
\t\t    $mat@Translate[15 i, 35];
\t\t    $mat@Rotate[-90.];
\t\t    g@Transform = $mat;
\t\t    g@DrawPolygon[$pen2, $shipPts],
            {i, $shipsLeft}
        ]
    ]
    

(* This function is wired to the game panel's Paint event. *)
onPaintGame[obj_, evt_] :=
\tModule[{g, posX, posY, lastXPos, lastYPos, pts, shipCenter, ticks, \
timeSinceExplodeBegan},
\t\tg = evt@Graphics;
\t\tFunction[thisBullet,
\t\t    g@DrawRectangle[$pen, thisBullet[[1]], thisBullet[[2]], 2, 2]
\t\t] /@ $bullets;
\t\t$mat@Reset[];
\t\tSwitch[$gameState,
\t\t    \"new\",
\t\t        g@DrawString[\"CLICK TO START\", $font, $brush, $FieldWidth/2., \
$FieldHeight/2., $format],
\t\t    \"running\",
\t\t        $mat@Translate[$ship[[1]], $ship[[2]]];
\t\t        $mat@Rotate[$ship[[5]] 360./(2Pi)];
\t\t        g@Transform = $mat;
\t\t        g@DrawPolygon[$pen, $shipPts];
\t\t        If[$isThrusting,
\t\t            g@DrawPolygon[$pen2, $thrustPts];
\t\t        ];
\t\t        $mat@Reset[],
\t\t    \"shipexploding\",
\t\t        timeSinceExplodeBegan = Environment`TickCount - $ship[[6]];
\t\t        Function[{pt1, pt2},
\t\t            $mat@Translate[$ship[[1]], $ship[[2]]];
\t\t            $mat@Rotate[$ship[[5]] 360./(2Pi) + \
(timeSinceExplodeBegan)/4000 Random[Real, {-180, 180}]];
\t\t            g@Transform = $mat;
\t\t            g@DrawLine[$pen, pt1[[1]], pt1[[2]], pt2[[1]], pt2[[2]]];
\t\t            $mat@Reset[];
\t\t        ] @@@ Partition[$ShipHitOutline, 2, 1, {1,1}],
\t\t    \"over\",
\t\t        g@DrawString[\"GAME OVER\", $font, $brush, $FieldWidth/2., \
$FieldHeight/2., $format]
\t\t];
\t\tlastXPos = lastYPos = 0;
\t\tFunction[thisAsteroid,
\t\t\tposX = thisAsteroid[[1]];
\t\t\tposY = thisAsteroid[[2]];
\t\t\t$mat@Translate[posX - lastXPos, posY - lastYPos];
\t\t\tlastXPos = posX;
\t\t\tlastYPos = posY;
\t\t\tg@Transform = $mat;
\t\t\tg@DrawPolygon[$pen, thisAsteroid[[-1]]];
\t\t] /@ $asteroids;
\t]


(* Wired to the timer's Tick event. *)
updateGame[] :=
\tModule[{timeDelta, keys, v, h, newMoveAngle, newSpeed},
\t    ticks = Environment`TickCount;
\t    timeDelta = ticks - $lastFrameTicks;
\t    $lastFrameTicks = ticks;
\t\t$asteroids = move[#, timeDelta]& /@ $asteroids;
\t\t$bullets = DeleteCases[move[#, timeDelta]& /@ $bullets, Null];
\t\t$bullets = Select[$bullets, !hitAsteroid[#]&];
\t\tIf[$score > $ShipBonusScore $bonusCount, $shipsLeft++; $bonusCount++; \
$scorePanel@Invalidate[]];
\t\tSwitch[$gameState,
\t\t    \"running\",
\t\t        $ship = move[$ship, timeDelta];
                If[shipHit[],
\t\t\t        playSnd[\"shipexplode\"];
\t\t\t        $gameState = \"shipexploding\";
\t\t\t        $ship = ReplacePart[$ship, Environment`TickCount, 6];
\t\t\t        Return[]
\t\t        ];
\t\t        GetKeyboardState[$keyArray];
\t\t        keys = NETObjectToExpression[$keyArray];
\t\t        If[keys[[38]] > 127,  (* Left arrow *)
\t\t\t        $ship = ReplacePart[$ship, $ship[[5]] - $ShipRotationSpeed, 5]
\t\t        ];
\t\t        If[keys[[40]] > 127,  (* Right arrow *)
\t\t\t        $ship = ReplacePart[$ship, $ship[[5]] + $ShipRotationSpeed, 5]
\t\t        ];
\t\t        If[keys[[39]] > 127,  (* Up arrow *)
\t\t            $isThrusting = True;
\t\t\t        playSnd[\"thrust\"];
\t\t            v = $ThrustBoost Sin[$ship[[5]]] + $ship[[3]] \
Sin[$ship[[4]]];
\t\t            h = $ThrustBoost Cos[$ship[[5]]] + $ship[[3]] \
Cos[$ship[[4]]];
\t\t            If[h == 0., h = 0.00001];
\t\t            If[v == 0., v = 0.00001];
\t\t            newMoveAngle = ArcTan[v/h];
\t\t            If[h == 0., h = 0.0001];
\t\t            newSpeed = v/Sin[newMoveAngle];
\t\t\t        $ship = ReplacePart[$ship, {newSpeed, newMoveAngle}, {{3}, \
{4}}, {{1}, {2}}],
\t\t        (* else *)
\t\t            $isThrusting = False;
\t\t            playSnd[\"nothrust\"];
\t\t            (* Speed wanes unless thrust is applied. *)
\t\t\t        $ship = ReplacePart[$ship, $ship[[3]](1 - $SpeedAttrition), 3]
\t\t        ];
\t\t        If[keys[[41]] > 127,  (* Down arrow *)
\t\t            (* \"Hyperspace\" jump to random position. *)
\t\t\t        $ship = ReplacePart[$ship, {Random[Integer, {0, $FieldWidth}], \
Random[Integer, {0, $FieldHeight}]}, {{1}, {2}}, {{1}, {2}}]
\t\t        ];
\t\t        If[keys[[33]] > 127 || keys[[18]] > 127,  (* Space or Control *)
\t\t            If[Length[$bullets] < $MaxBullets,
\t\t                ticks = Environment`TickCount;
\t\t                If[ticks >= $lastFireTime + $FireInterval,
\t\t                    $lastFireTime = ticks;
\t\t\t                AppendTo[$bullets, Bullet[$ship[[1]] + 8 \
Cos[$ship[[5]]], $ship[[2]] + 8 Sin[$ship[[5]]], $BulletSpeed, $ship[[5]]]];
\t\t\t                playSnd[\"fire\"]
\t\t\t            ]
\t\t\t        ]
\t\t        ];
\t\t        If[Length[$asteroids] == 0,
\t\t            $level++;
\t\t            $asteroids = Table[createAsteroid[\"large\", \
randomEdgePosition[]], {$NumStartingAsteroids + $level}];
\t\t        ],
\t\t    \"shipexploding\",
\t\t        timeSinceExplodeBegan = Environment`TickCount - $ship[[6]];
\t\t        If[timeSinceExplodeBegan > 2500,
\t\t            $gameState = \"waitingforship\"
\t\t        ],
\t\t    \"waitingforship\",
\t\t        If[$shipsLeft > 0,
\t\t            $ship = Ship[$FieldWidth/2, $FieldHeight/2, 0, 0, 0., 0];
\t\t            $bullets = {};
\t\t            $lastFireTime = 0;
\t\t            $gameState = \"running\";
    \t\t        $shipsLeft--;
    \t\t        $scorePanel@Invalidate[],
    \t\t    (* else *)
\t\t            $gameState = \"over\"
    \t\t    ]
\t\t];
\t]


playSnd[soundType_String] :=
    Module[{soundFile},
        soundFile =
            Switch[soundType,
                \"thrust\", ToFileName[{$TopDirectory, \"AddOns\", \
\"NETLink\", \"Examples\", \"Part1\", \"Windows and Dialogs\", \
\"AsteroidsGame\"}, \"thrust.wav\"],
                \"fire\", ToFileName[{$TopDirectory, \"AddOns\", \"NETLink\", \
\"Examples\", \"Part1\", \"Windows and Dialogs\", \"AsteroidsGame\"}, \
\"fire.wav\"],
                \"asteroidexplode\", ToFileName[{$TopDirectory, \"AddOns\", \
\"NETLink\", \"Examples\", \"Part1\", \"Windows and Dialogs\", \
\"AsteroidsGame\"}, \"asteroidexplode.wav\"],
                \"shipexplode\", ToFileName[{$TopDirectory, \"AddOns\", \
\"NETLink\", \"Examples\", \"Part1\", \"Windows and Dialogs\", \
\"AsteroidsGame\"}, \"shipexplode.wav\"]
            ];                
        Which[
            soundType == \"thrust\",
                If[$curSound != \"thrust\", PlaySound[soundFile, 0, 9 (* \
SND_LOOP | SND_ASYNC *)]],
            soundType == \"nothrust\",
                If[$curSound == \"thrust\", PlaySound[Null, 0, 1 (* SND_ASYNC \
*)]],
            True,
                PlaySound[soundFile, 0, 1 (* SND_ASYNC *)]
        ];
        $curSound = soundType
    ]

    
move[Ship[posX_, posY_, speed_, moveDir_, noseDir_, explodeTicks__], \
timeDelta_] :=
    Module[{mewX, newY},
\t\t{newX, newY} = wrapCoords[posX + speed (timeDelta $FrameRate/1000.) \
Cos[moveDir], posY + speed (timeDelta $FrameRate/1000.) Sin[moveDir]];
\t\tShip[newX, newY, speed, moveDir, noseDir, explodeTicks]
    ]

move[Bullet[posX_, posY_, speed_, dir_], timeDelta_] :=
\tModule[{newX, newY},
\t\tnewX = posX + speed (timeDelta $FrameRate/1000.) Cos[dir];
\t\tnewY = posY + speed (timeDelta $FrameRate/1000.) Sin[dir];
\t\tIf[newX > $FieldWidth || newX < 0 || newY > $FieldHeight || newY < 0,
\t\t    (* Has left screen. *)
\t\t    Null,
\t\t(* else *)
\t\t    Bullet[newX, newY, speed, dir]\t
\t\t]
\t]

move[asteroid[posX_, posY_, speed_, dir_, rest___], timeDelta_] :=
\tModule[{newX, newY},
\t\t{newX, newY} = wrapCoords[posX + speed (timeDelta $FrameRate/1000.) \
Cos[dir], posY + speed (timeDelta $FrameRate/1000.) Sin[dir]];
\t\tasteroid[newX, newY, speed, dir, rest]\t
\t]


(* Wraps coords when they hit the boundaries of the panel, so that objects \
reappear on the other side. *)
wrapCoords[posX_, posY_] :=
    Module[{newX = posX, newY = posY},
\t\tWhich[
\t\t\tnewX > $FieldWidth, newX = newX - $FieldWidth,
\t\t\tnewX < 0, newX = newX + $FieldWidth
\t\t];
\t\tWhich[
\t\t\tnewY > $FieldHeight, newY = newY - $FieldHeight,
\t\t\tnewY < 0, newY = newY + $FieldHeight
\t\t];
\t\t{newX, newY}
    ]


(* Decides whether a bullet has hit any of the asteroids. *)
hitAsteroid[Bullet[posX_, posY_, __]] :=
    Module[{asteroidIndex = 1, hit, radius, asteroidX, asteroidY, newRadius},
        hit = Scan[(If[Sqrt[(posX - #[[1]])^2 + (posY - #[[2]])^2] < #[[-2]], \
Return[asteroidIndex]]; asteroidIndex++)&, $asteroids];
        If[IntegerQ[hit],
\t\t\tplaySnd[\"asteroidexplode\"];
            {asteroidX, asteroidY, radius} = Extract[$asteroids[[hit]], {{1}, \
{2}, {5}}];
            $asteroids = Delete[$asteroids, {hit}];
\t\t    Switch[radius,
\t\t\t    $LargeAsteroidRadius,
\t\t\t        $score += 20;
                    AppendTo[$asteroids, createAsteroid[\"medium\", \
{asteroidX, asteroidY}]];
                    AppendTo[$asteroids, createAsteroid[\"medium\", \
{asteroidX, asteroidY}]],
\t\t\t    $MediumAsteroidRadius, 
\t\t\t        $score += 50;
                    AppendTo[$asteroids, createAsteroid[\"small\", \
{asteroidX, asteroidY}]];
                    AppendTo[$asteroids, createAsteroid[\"small\", \
{asteroidX, asteroidY}]],
\t\t\t    $SmallAsteroidRadius, 
\t\t\t        $score += 100
\t\t    ];
\t\t    $scorePanel@Invalidate[];
            True,
        (* else *)
            False
        ]
    ]


shipHit[] :=
    Module[{nose, leftSide, rightSide, leftWing, rightWing, tail, posX, posY, \
noseDir, hit, astX, astY, radius},
        {posX, posY, noseDir} = Extract[$ship, {{1}, {2}, {5}}];
        {nose, leftSide, rightSide, leftWing, rightWing, tail} = (# + {posX, \
posY}&) /@ (Rotate2D[#, noseDir]&) /@ $ShipHitOutline;
        hit = Scan[
                 Function[{thisAsteroid},
                     {astX, astY, radius} = Extract[thisAsteroid, {{1}, {2}, \
{5}}];
                     hit = Scan[If[Sqrt[(astX - #[[1]])^2 + (astY - \
#[[2]])^2] <= radius, Return[True]]&,
                            {nose, leftSide, rightSide, leftWing, rightWing, \
tail}];
                     If[TrueQ[hit], Return[True]]
                 ],
                 $asteroids
              ];
        TrueQ[hit]
    ]
    
    
Asteroids[] :=
\tNETBlock[
\t\tModule[{frm, timer, gamePanel, timerDelegate, onTimerTick, onClick},
\t\t    InstallNET[];
\t\t    
\t\t\t(*****  DLL function defs  *****)
\t\t\tGetKeyboardState = DefineDLLFunction[\"GetKeyboardState\", \"user32.dll\
\", \"bool\", {\"byte[]\"}];\t\t\t
\t\t\tPlaySound = DefineDLLFunction[\"PlaySound\", \"winmm.dll\", \"bool\", {\
\"string\", \"int\", \"int\"}];
\t\t\t
\t\t\t(*****  Prepare the game  *****)
\t\t    $shipPts = NETNew[\"System.Drawing.Point\", ##]& @@@ $ShipOutline;
\t\t    $thrustPts = NETNew[\"System.Drawing.PointF\", ##]& @@@ \
$ThrustOutline;\t        
\t        $largeAsteroidPts =  Apply[NETNew[\"System.Drawing.PointF\", ##]&, \
($LargeAsteroidRadius $AsteroidOutlines), {2}];
\t        $mediumAsteroidPts =  Apply[NETNew[\"System.Drawing.PointF\", ##]&, \
($MediumAsteroidRadius $AsteroidOutlines), {2}];
\t        $smallAsteroidPts =  Apply[NETNew[\"System.Drawing.PointF\", ##]&, \
($SmallAsteroidRadius $AsteroidOutlines), {2}];
            
\t\t    resetGame[];
\t\t    
\t\t\t(*****  Load some necessary types from which we need to access static \
members.  *****)
\t\t\tLoadNETType[\"System.Drawing.Color\"];
\t\t\tLoadNETType[\"System.Drawing.StringAlignment\"];
\t\t\tLoadNETType[\"System.Windows.Forms.AnchorStyles\"];
\t\t\tLoadNETType[\"System.Windows.Forms.FormBorderStyle\"];
\t\t\tLoadNETType[\"System.Environment\"];
\t\t\t
\t\t\t(*****  Create the UI  *****)        
\t\t\tfrm = NETNew[\"System.Windows.Forms.Form\"];
\t\t\tfrm@Text = \"Asteroids\";
            frm@FormBorderStyle = FormBorderStyle`FixedSingle;
            frm@MaximizeBox = False;
\t\t\tfrm@ClientSize = NETNew[\"System.Drawing.Size\", $FieldWidth, \
$FieldHeight + 60];
\t\t\t$scorePanel = NETNew[\"Wolfram.NETLink.UI.DoubleBufferedPanel\"];
\t\t\t$scorePanel@Size = NETNew[\"System.Drawing.Size\", $FieldWidth, 60];
\t\t\t$scorePanel@Parent = frm;
\t\t\t$scorePanel@BackColor = Color`Black;
\t\t\tgamePanel = NETNew[\"Wolfram.NETLink.UI.DoubleBufferedPanel\"];
\t\t\tgamePanel@Parent = frm;
\t\t\tgamePanel@BackColor = Color`Black;
\t\t\tgamePanel@Size = NETNew[\"System.Drawing.Size\", $FieldWidth, \
$FieldHeight];
\t\t\tgamePanel@Top = 60;
\t\t\tAddEventHandler[$scorePanel@Paint, onPaintScore];
\t\t\tAddEventHandler[gamePanel@Paint, onPaintGame];
\t\t\tAddEventHandler[gamePanel@Click, startGame, SendDelegateArguments -> \
None];
\t\t\tAddEventHandler[frm@Closing, (RemoveEventHandler[timer@Tick, \
timerDelegate]; timer@Stop[])&, SendDelegateArguments -> None];
\t\t\tstartGame[] :=
\t\t\t    Switch[$gameState,
\t\t\t        \"over\",
                        resetGame[];
                        $gameState = \"new\";
\t\t\t            $scorePanel@Invalidate[],
\t\t\t        \"new\",
\t\t\t            $gameState = \"running\";
\t\t\t            $shipsLeft--;
\t\t\t            $scorePanel@Invalidate[]
                ];
                
\t\t\t(*****  Prepare the timer  *****)
\t\t\ttimer = NETNew[\"System.Windows.Forms.Timer\"];
\t\t\ttimer@Interval = Round[1000./$FrameRate];
\t\t\tonTimerTick[] := (updateGame[]; gamePanel@Refresh[]);
\t\t\ttimerDelegate = AddEventHandler[timer@Tick, onTimerTick, \
SendDelegateArguments -> None];
\t\t\ttimer@Start[];

\t\t\t$pen = NETNew[\"System.Drawing.Pen\", Color`White, 1];
\t\t\t$pen2 = NETNew[\"System.Drawing.Pen\", Color`White, 2];
\t\t\t$font = NETNew[\"System.Drawing.Font\", \"Arial\", 16];
            $brush = NETNew[\"System.Drawing.SolidBrush\", Color`White];
            $format = NETNew[\"System.Drawing.StringFormat\"];
            $format@Alignment = StringAlignment`Center;

\t\t\t$mat = NETNew[\"System.Drawing.Drawing2D.Matrix\"];
\t\t\t$keyArray = NETNew[\"System.Byte[]\", 256];
\t\t\t
\t\t\t(*****  Show the UI and run the game  *****)
\t\t\t
\t\t\tDoNETModal[frm];
\t\t\t
\t\t\t(*****  Turns off any looping sounds.  ******)
\t\t\tPlaySound[Null, 0, 1 (* SND_ASYNC *)];\t\t\t
\t\t]
\t]

If[!wasOff1, On[General::spell]];
If[!wasOff2, On[General::spell1]];

End[];

EndPackage[];\
\>", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell["\<\
Use the arrow keys to control the ship, and the space bar to fire. Left and \
right arrows rotate the ship, up arrow is thrust, and down arrow is the \
\"hyperspace\" command, which randomly relocates your ship (useful in an \
emergency). Close the window any time to end the game.\
\>", "Text"],

Cell["Asteroids[]", "Input"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{990, 650},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 2725, 83, 371, "Title"],
Cell[CellGroupData[{
Cell[3340, 110, 23, 0, 67, "Section"],
Cell[3366, 112, 18543, 543, 8616, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[21946, 660, 26, 0, 37, "Section"],
Cell[21975, 662, 305, 5, 41, "Text"],
Cell[22283, 669, 28, 0, 24, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

